VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------------------
' The SQL table used here is called "ImageTable" and it's setup like this:
'
' ImageID   = int      (Primary Key / IDENTITY)
' dCreated  = datetime (Default value = GETDATE())
' ImageItem = image    (Allows NULL)
'
'------------------------------------------------------------------------------

Private Const strServerName As String = "LOCALHOST"
Private Const strServerDB   As String = "TEST"
Private Const strServerUser As String = "" ' NT Authentication
Private Const strServerPass As String = "" ' NT Authentication
Private Const strFileIn     As String = "C:\TEST.BMP"
Private Const strFileOut    As String = "C:\DUMP.BMP"

Private Sub Form_Load()
On Error GoTo ErrorTrap
   
   Dim objConn    As ADODB.Connection
   Dim objRS      As ADODB.Recordset
   Dim FileNum    As Integer
   Dim strIN      As String
   Dim strOUT     As String
   Dim strSQL     As String
   Dim strErrDesc As String
   Dim lngErrNum  As Long
   
   ' Input the image file as TEXT
   FileNum = FreeFile()
   Open strFileIn For Binary As #FileNum
      strIN = Space(LOF(FileNum))
      Get #FileNum, , strIN
   Close FileNum
   
'--------------------------------------------------
   
   ' Open connection to database
   Set objConn = New ADODB.Connection
   objConn.Open "Driver={SQL Server};SERVER=" & strServerName & ";DATABASE=" & strServerDB & ";UID=" & strServerUser & ";PWD=" & strServerPass & ";"
   
   ' Get a record from the database to get the proper field information for the table
   Set objRS = New ADODB.Recordset
   strSQL = "SELECT TOP 1 * " & _
            "FROM ImageTable"
   objRS.Open strSQL, objConn, adOpenStatic, adLockOptimistic, adCmdText
   
   ' Add the image to the database
   objRS.AddNew
   objRS.Fields("ImageItem").AppendChunk strIN
   objRS.Update
   objRS.Close
   Set objRS = Nothing
   
'--------------------------------------------------
   
   ' Get the last image inserted into the table
   Set objRS = New ADODB.Recordset
   strSQL = "SELECT * " & _
            "FROM ImageTable " & _
            "WHERE ImageID = (SELECT MAX(ImageID) FROM ImageTable)"
   objRS.Open strSQL, objConn, adOpenStatic, adLockReadOnly, adCmdText
   If Trim(objRS("ImageItem").Value & "") <> "" Then
      strOUT = Space(objRS.Fields("ImageItem").ActualSize)
      strOUT = objRS.Fields("ImageItem").Value
   End If
   
'--------------------------------------------------
   
   ' Save the image to file
   If strOUT <> "" Then
      If Dir(strFileOut, vbArchive Or vbHidden Or vbNormal Or vbReadOnly Or vbSystem) <> "" Then Kill strFileOut
      FileNum = FreeFile()
      Open strFileOut For Binary As #FileNum
         Put #FileNum, , strOUT
      Close #FileNum
   End If
   
'--------------------------------------------------
   
   ' Load the image from file
   Set Me.Picture = LoadPicture(strFileOut)
   
CleanUp:
   
   If Not objConn Is Nothing Then
      If objConn.State <> adStateClosed Then objConn.Close
      Set objConn = Nothing
   End If
   
   If Not objRS Is Nothing Then
      If objRS.State <> adStateClosed Then objRS.Close
      Set objRS = Nothing
   End If
   Exit Sub
   
ErrorTrap:
   
   lngErrNum = Err.Number
   strErrDesc = Err.Description
   Err.Clear
   If lngErrNum = 0 Or lngErrNum = 20 Then Resume Next
   MsgBox "An error just occured:" & Chr(13) & Chr(13) & "Error Number = " & CStr(lngErrNum) & Chr(13) & "Error Description = " & strErrDesc, vbOKOnly + vbExclamation, "  Error"
   GoTo CleanUp
   
End Sub
